<?php
class RedsysAPI {
    private $params;
    private $signature;
    private $merchantParameters;

    public function __construct() {
        $this->params = array();
        $this->signature = null;
        $this->merchantParameters = null;
    }

    public function setParameter($key, $value) {
        $this->params[$key] = $value;
    }

    public function createMerchantParameters() {
        $json = json_encode($this->params);
        return base64_encode($json);
    }

    public function createMerchantSignature($key) {
        $decodedKey = base64_decode($key);
        $order = $this->params['DS_MERCHANT_ORDER'];
        $keyDerivation = $this->encrypt_3DES($order, $decodedKey);
        $this->signature = base64_encode(hash_hmac('sha256', $this->createMerchantParameters(), $keyDerivation, true));
        return $this->signature;
    }

    private function encrypt_3DES($message, $key) {
        $ciphertext = openssl_encrypt($message, 'des-ede3-cbc', $key, OPENSSL_RAW_DATA, "        ");
        return $ciphertext;
    }
}
?>
